% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend.R
\name{k_spatial_3d_padding}
\alias{k_spatial_3d_padding}
\title{Pads 5D tensor with zeros along the depth, height, width dimensions.}
\usage{
k_spatial_3d_padding(x, padding = list(list(1, 1), list(1, 1), list(1, 1)),
  data_format = NULL)
}
\arguments{
\item{x}{Tensor or variable.}

\item{padding}{List of 3 lists, padding pattern.}

\item{data_format}{string, \code{"channels_last"} or \code{"channels_first"}.}
}
\value{
A padded 5D tensor.
}
\description{
Pads these dimensions with respectively \code{padding[[1]]}, \code{padding[[2]]}, and
\code{padding[[3]]} zeros left and right. For 'channels_last' data_format, the
2nd, 3rd and 4th dimension will be padded. For 'channels_first' data_format,
the 3rd, 4th and 5th dimension will be padded.

[[1]: R:[1
[[2]: R:[2
[[3]: R:[3
}
\section{Keras Backend}{


This function is part of a set of Keras backend functions that enable
lower level access to the core operations of the backend tensor engine
(e.g. TensorFlow, CNTK, Theano, etc.).

You can see a list of all available backend functions here:
\url{https://keras.rstudio.com/articles/backend.html#backend-functions}.
}

