% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kappa.R
\name{simulKappa}
\alias{simulKappa}
\title{Simulate rating data and calculate agreement with gold standard}
\usage{
simulKappa(nRater, cats, nSubj, probs, mcSim = 10, simOnly = FALSE)
}
\arguments{
\item{nRater}{numeric. number of raters.}

\item{cats}{categories specified either as character vector or just the
numbers of categories.}

\item{nSubj}{numeric. number of subjects per gold standard category. Either a
single number or as vector of numbers per category, e.g. for non-balanced
situation.}

\item{probs}{numeric square matrix (nCat x nCat) with classification
probabilities. Row \code{i} has probabilities of rater categorization for
subjects of category \code{i} (gold standard).}

\item{mcSim}{numeric. Number of Monte-Carlo simulations.}

\item{simOnly}{logical. Need only simulation data? Default is \code{FALSE}.}
}
\value{
dataframe of kappa-gold on the simulated datasets or (when
\code{simOnly=TRUE}) list of length \code{mcSim} with each element a simulated data
set with goldrating in first column and then the raters.
}
\description{
The function generates simulation data according to given categories and probabilities.
and can repeatedly apply function \code{\link[=kappam_gold]{kappam_gold()}}.
Currently, there is no variation in probabilities from rater to rater,
only sampling variability from multinomial distribution is at work.
}
\details{
This function is future-aware for the repeated evaluation of \code{\link[=kappam_gold]{kappam_gold()}}
that is triggered by this function.
}
\examples{
# repeatedly estimate agreement with goldstandard for simulated data
simulKappa(nRater = 8, cats = 3, nSubj = 11,
           # assumed prob for classification by raters
           probs = matrix(c(.6, .2, .1, # subjects of cat 1
                            .3, .4, .3, # subjects of cat 2
                            .1, .4, .5  # subjects of cat 3
           ), nrow = 3, byrow = TRUE))


}
