% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kanji2.R
\name{kmatdistmat}
\alias{kmatdistmat}
\title{Compute distance matrix for lists of kanjimat objects}
\usage{
kmatdistmat(
  klist,
  klist2 = NULL,
  p = 1,
  C = 0.2,
  type = c("unbalanced", "balanced")
)
}
\arguments{
\item{klist}{a list of \code{\link{kanjimat}} objects.}

\item{klist2}{an optional second list of \code{\link{kanjimat}} objects.}

\item{p, C, type}{the same as for the function \code{\link{kmatdist}}.}
}
\value{
A matrix of dimension \code{length(klist)} x \code{length(klist2)} having
as its \eqn{(i,j)}-th entry the distance between \code{klist[[i]]} and
\code{klist2[[j]]}. If \code{klist2} is not provided it is assumed to be equal to
\code{klist}, but the computation is more efficient as only the upper triangular part
is computed and then symmetrized with diagonal zero.
}
\description{
Apply \code{\link{kmatdist}} to every pair of \code{\link{kanjimat}} objects to compute
the unbalanced or balanced Wasserstein distance.
}
\examples{
kmatdistmat(fivetrees1)
\donttest{kmatdistmat(fivetrees1, fivetrees1)  # same result but slower
kmatdistmat(fivetrees1, fivetrees2)  # note the smaller values on the diagonal
}

}
\seealso{
\code{\link{kmatdist}}, \code{\link{kanjidistmat}}
}
