% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/seriation_permute.R
\docType{methods}
\name{order}
\alias{order}
\alias{order_rows}
\alias{order_rows-method}
\alias{order_columns}
\alias{order_columns-method}
\alias{order_rows,PermutationOrder-method}
\alias{order_columns,PermutationOrder-method}
\title{Permutation Order}
\usage{
order_rows(object, ...)

order_columns(object, ...)

\S4method{order_rows}{PermutationOrder}(object)

\S4method{order_columns}{PermutationOrder}(object)
}
\arguments{
\item{object}{A \code{\linkS4class{PermutationOrder}} object giving the permutation
order for rows and columns.}

\item{...}{Currently not used.}
}
\value{
An \code{\link{integer}} vector.
}
\description{
Returns the seriation order for rows and/or columns.
}
\examples{
## Replicates Desachy 2004 results
data("compiegne", package = "folio")

## Get seriation order for columns on EPPM using the reciprocal averaging method
## Expected column order: N, A, C, K, P, L, B, E, I, M, D, G, O, J, F, H
(indices <- seriate_rank(compiegne, EPPM = TRUE, margin = 2))

## Get permutation order
order_rows(indices)
order_columns(indices)

## Permute columns
(new <- permute(compiegne, indices))
}
\seealso{
Other seriation methods: 
\code{\link{as_seriation}()},
\code{\link{assess}()},
\code{\link{permute}()},
\code{\link{refine}()},
\code{\link{seriate_average}()},
\code{\link{seriate_rank}()}
}
\author{
N. Frerebeau
}
\concept{seriation methods}
