% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell_spec.R
\name{cell_spec}
\alias{cell_spec}
\alias{text_spec}
\title{Specify Cell/Text format}
\usage{
cell_spec(x, format, bold = FALSE, italic = FALSE, monospace = FALSE,
  underline = FALSE, strikeout = FALSE, color = NULL,
  background = NULL, align = NULL, font_size = NULL, angle = NULL,
  tooltip = NULL, popover = NULL, link = NULL, extra_css = NULL,
  escape = TRUE, background_as_tile = TRUE,
  latex_background_in_cell = TRUE)

text_spec(x, format, bold = FALSE, italic = FALSE, monospace = FALSE,
  underline = FALSE, strikeout = FALSE, color = NULL,
  background = NULL, align = NULL, font_size = NULL, angle = NULL,
  tooltip = NULL, popover = NULL, link = NULL, extra_css = NULL,
  escape = TRUE, background_as_tile = TRUE,
  latex_background_in_cell = FALSE)
}
\arguments{
\item{x}{Things to be formated. It could be a vector of numbers or strings.}

\item{format}{Either "html" or "latex". It can also be set through
\code{option(knitr.table.format)}, same as \code{knitr::kable()}.}

\item{bold}{T/F for font bold.}

\item{italic}{T/F for font italic.}

\item{monospace}{T/F for font monospaced (verbatim)}

\item{underline}{A T/F value to control whether the text of the selected row
need to be underlined}

\item{strikeout}{A T/F value to control whether the text of the selected row
need to be stricked out.}

\item{color}{A character string for text color. Here please pay
attention to the differences in color codes between HTML and LaTeX.}

\item{background}{A character string for background color. Here please
pay attention to the differences in color codes between HTML and LaTeX. Also
note that in HTML, background defined in cell_spec won't cover the whole
cell.}

\item{align}{A character string for cell alignment. For HTML, possible
values could be \code{l}, \code{c}, \code{r} plus \code{left}, \code{center}, \code{right}, \code{justify},
\code{initial} and \code{inherit} while for LaTeX, you can only choose
from \code{l}, \code{c} & \code{r}.}

\item{font_size}{A numeric input for font size. For HTML, you can also use
options including \code{xx-small}, \code{x-small}, \code{small}, \code{medium}, \code{large},
\code{x-large}, \code{xx-large}, \code{smaller}, \code{larger}, \code{initial} and \code{inherit}.}

\item{angle}{0-360, degree that the text will rotate. Can be a vector.}

\item{tooltip}{A vector of strings to be displayed as tooltip.
Obviously, this feature is only available in HTML. Read the package
vignette to see how to use bootstrap tooltip css to improve the loading
speed and look.}

\item{popover}{Similar with tooltip but can hold more contents. The best way
to build a popover is through \code{spec_popover()}. If you only provide a text
string, it will be used as content. Note that You have to enable this
bootstrap module manually. Read the package vignette to see how.}

\item{link}{A vector of strings for url links. Can be used together with
tooltip and popover.}

\item{extra_css}{Extra css text to be passed into the cell}

\item{escape}{T/F value showing whether special characters should be escaped.}

\item{background_as_tile}{T/F value indicating if you want to have round
cornered tile as background in HTML.}

\item{latex_background_in_cell}{T/F value. It only takes effect in LaTeX
when \code{background} provided, Default value is \code{TRUE}. If it's \code{TRUE}, the
background only works in a table cell. If it's \code{FALSE}, it works outside of a
table environment.}
}
\description{
Specify Cell format before it gets into kable
}
