% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testing.r
\name{expect_that_combine_all_args}
\alias{expect_that_combine_all_args}
\alias{expect_that_combine_first_arg}
\title{alternative \code{expect_that} from \code{testthat} which permutes all
  the inputs to a function which should give the same result where n args >=2
  and the function is commutative.}
\usage{
expect_that_combine_all_args(object, condition, info = NULL,
  label = NULL)

expect_that_combine_first_arg(object, condition, info = NULL,
  label = NULL)
}
\arguments{
\item{object}{See \code{\link[testthat]{expect_that}}.}

\item{condition}{See \code{\link[testthat]{expect_that}}.}

\item{info}{See \code{\link[testthat]{expect_that}}.}

\item{label}{See \code{\link[testthat]{expect_that}}.}
}
\value{
testthat result
}
\description{
This makes a lot of assumptions, needs more testing. It can't
  handle mixed error/no error outcomes after permutation, which is an
  important feature to consider. The command following this function attaches
  this function to the testthat namespace. This means that it can call
  internal testthat functions, but does not mean it appears as
  testthat::expect_that_combine
}
\examples{
expect_that_combine_all_args(
  sum(1, 2, 3),
  testthat::equals(6)
)
\dontrun{
expect_that_combine_all_args(stop("a", "b"), testthat::throws_error())
expect_that_combine_all_args(sum(1, 2), testthat::equals(3))
expect_that_combine_first_arg(sum(c(1, 2)), testthat::equals(3))
}
}
