% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_justifications.R
\name{parse_justifications}
\alias{parse_justifications}
\title{Parsing justifications}
\usage{
parse_justifications(x)
}
\arguments{
\item{x}{An object resulting from a call to \code{\link[yum:load_and_simplify]{yum::load_and_simplify()}}.}
}
\value{
The parsed \code{justifier} object
}
\description{
This function is normally called by \code{\link[=load_justifications]{load_justifications()}}; however,
sometimes it may be desirable to parse justifications embedded in more
complex objects, for example as provided by \code{\link[yum:load_and_simplify]{yum::load_and_simplify()}}.
Therefore, this function can also be called directly.
}
\details{
While there is some flexibility in how justifications can be specified,
they are most easily processed further if they all follow the same
conventions. This function ensures this. The convention is as follows:
\itemize{
\item all specifications are provided in four 'flat' lists, named after the
types of elements they contain;
\item all elements have  a unique identifier
\item all references to other elements are indeed only references to the other
elements' id's in these 'flat lists'
}
}
\examples{
### Specify an example text
exampleFile <-
  system.file("extdata",
              "simple-example.jmd",
              package="justifier");

### Show contents
cat(readLines(exampleFile), sep="\\n");

### Load it with yum::load_and_simplify()
loadedMinutes <- yum::load_and_simplify(exampleFile);

### Show contents
names(loadedMinutes);

### Parse 'manually'
parsedJustifications <- justifier::parse_justifications(loadedMinutes);

### Show contents
names(parsedJustifications);

}
