% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_two_tier.R
\name{a_two_tier}
\alias{a_two_tier}
\title{Two Tier Analysis Function}
\usage{
a_two_tier(
  df,
  labelstr = NULL,
  .var,
  .N_col,
  .df_row,
  inner_var,
  drill_down_levs,
  .spl_context,
  use_all_levels = FALSE,
  grp_fun,
  detail_fun,
  .alt_df_full = NULL,
  ...
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{labelstr}{(\code{character})\cr label of the level of the parent split currently being summarized
(must be present as second argument in Content Row Functions). See \code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}}
for more information.}

\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{.N_col}{(\code{integer})\cr column-wise N (column count) for the full column being analyzed that is typically
passed by \code{rtables}.}

\item{.df_row}{(\code{data.frame})\cr data frame across all of the columns for the given row split.}

\item{inner_var}{(\code{string})\cr single variable name to use when generating
the detail rows.}

\item{drill_down_levs}{(\code{character})\cr the level(s) of \code{.var} under which
detail rows should be generated.}

\item{.spl_context}{(\code{data.frame})\cr gives information about ancestor split states
that is passed by \code{rtables}.}

\item{use_all_levels}{(\code{flag})\cr controls which factor levels will be
present for \code{inner_var} (both in \code{df}/\code{x} and in \code{.df_row}) when calling
\code{detail_fun}.
If \code{TRUE}, all levels (those present on the factor \code{.df_row[[inner_var]]},
*regardless if the level is observed in the row group or not) will be
present when creating detail rows.
Otherwise (the default), only the levels observed
\emph{anywhere in the row group, i.e., within \code{.df_row}} will be present.}

\item{grp_fun}{(\code{function})\cr analysis function to be used when generating
the "group summary" outer rows.}

\item{detail_fun}{(\code{function})\cr analysis function to be used when generating
"detail" inner rows.}

\item{.alt_df_full}{(\code{dataframe})\cr denominator dataset for fraction and
relative risk calculations.\cr
this argument gets populated by the rtables split machinery
(see \link[rtables:additional_fun_params]{rtables::additional_fun_params}).}

\item{...}{additional arguments passed directly to \code{grp_fun} and \code{detail_fun}.}
}
\value{
A \code{RowsVerticalSection} object including both the group row and all
detail rows, if applicable, for the facet.
}
\description{
The analysis function used as an \code{afun} in \link[rtables]{analyze}.
This function simulates a final additional level of nesting with a
traditional analyze call inside it.

This makes it possible to create what \emph{appear to be} group summary or
content rows and to \emph{optionally or conditionally} generate one or more
"detail" rows underneath it.

For example, in a disposition table, one might want counts for completed
and ongoing patients with no further detail underneath, but a breakdown of
specific reasons beneath the count of patients who discontinued treatment.
}
\details{
Both the analysis variable and \code{inner_var} must be factors.
Detail rows are differentiated by having an indent mod of one, causing them
to hang indented under their corresponding group row.
}
\note{
In its current form, this function may not retain any formatting or
labeling instructions added by \code{grp_fun} or \code{detail_fun}, and it will
override any \code{.indent_mods} values specified by them. This behavior may
change in future versions.
}
\examples{

# Example 1

lyt_obs_levels <- basic_table() |>
  split_cols_by("ARM") |>
  split_rows_by("EOSSTT", child_labels = "hidden") |>
  analyze("EOSSTT",
    afun = a_two_tier,
    extra_args = list(
      grp_fun = simple_analysis,
      detail_fun = simple_analysis,
      inner_var = "DCSREAS",
      drill_down_levs = "DISCONTINUED"
    )
  )

tbl <- build_table(lyt_obs_levels, ex_adsl)
tbl

lyt_all_levels <- basic_table() |>
  split_cols_by("ARM") |>
  split_rows_by("EOSSTT", child_labels = "hidden") |>
  analyze("EOSSTT",
    afun = a_two_tier,
    extra_args = list(
      grp_fun = simple_analysis,
      detail_fun = simple_analysis,
      inner_var = "DCSREAS",
      drill_down_levs = "DISCONTINUED",
      use_all_levels = TRUE
    )
  )

adsl_subset <- subset(ex_adsl, DCSREAS != "ADVERSE EVENT")
levels(adsl_subset$DCSREAS)

tbl_all_levels <- build_table(lyt_all_levels, adsl_subset)
tbl_all_levels

tbl_obs_levels <- build_table(lyt_obs_levels, adsl_subset)
tbl_obs_levels

# Example 2

library(dplyr)

trtvar <- "ARM"
ctrl_grp <- "B: Placebo"

adsl <- ex_adsl |> select(c("USUBJID", "STRATA1", "EOSSTT", "DCSREAS", all_of(trtvar)))
adsl$colspan_trt <- factor(
  ifelse(adsl[[trtvar]] == ctrl_grp, " ", "Active Study Agent"),
  levels = c("Active Study Agent", " ")
)
adsl$rrisk_header <- "Risk Difference (\%) (95\% CI)"
adsl$rrisk_label <- paste(adsl[[trtvar]], paste("vs", ctrl_grp))

colspan_trt_map <- create_colspan_map(
  df = adsl,
  non_active_grp = ctrl_grp,
  non_active_grp_span_lbl = " ",
  active_grp_span_lbl = "Active Study Agent",
  colspan_var = "colspan_trt",
  trt_var = trtvar
)

a_freq_j_args <- list(
  .stats = "count_unique_fraction",
  denom = "n_altdf",
  ref_path = c("colspan_trt", " ", trtvar, ctrl_grp)
)

two_tier_args <- list(
  grp_fun = a_freq_j,
  detail_fun = a_freq_j,
  inner_var = "DCSREAS",
  drill_down_levs = "DISCONTINUED"
)

lyt_rrisk <- basic_table() |>
  split_cols_by("colspan_trt", split_fun = trim_levels_to_map(map = colspan_trt_map)) |>
  split_cols_by(trtvar) |>
  split_cols_by("rrisk_header", nested = FALSE) |>
  split_cols_by(trtvar, labels_var = "rrisk_label", split_fun = remove_split_levels(ctrl_grp)) |>
  split_rows_by("STRATA1") |>
  split_rows_by("EOSSTT", child_labels = "hidden") |>
  analyze("EOSSTT", afun = a_two_tier, extra_args = c(two_tier_args, a_freq_j_args))

adsl_subset <- subset(
  adsl,
  EOSSTT != "COMPLETED" & (is.na(DCSREAS) | DCSREAS != "PROTOCOL VIOLATION")
)

tbl_rrisk <- build_table(lyt_rrisk, adsl_subset, alt_counts_df = adsl_subset)
tbl_rrisk

}
\author{
GB, WW.
}
