% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_new_data.R
\name{get_offset_name}
\alias{get_offset_name}
\alias{get_weights}
\alias{get_data}
\alias{get_response_name}
\title{Utility functions for generating model predictions}
\usage{
get_offset_name(model)

get_weights(model, data)

get_data(model, formula = NULL, warn = TRUE, ...)

get_response_name(model, ...)
}
\arguments{
\item{model}{The model (e.g., \code{lm}, \code{glm}, \code{merMod}, \code{svyglm})}

\item{data}{For \code{get_weights()}, the data used to fit the model.}

\item{formula}{The formula for \code{model}, if desired. Otherwise \code{get_formula()}
is called.}

\item{warn}{For \code{get_data()}, should there be a warning when \code{model.frame()}
won't work because of variable transformations? Default is TRUE but this
may not be desired when \code{get_data()} is used inside of another function or
used multiple times.}

\item{...}{Arguments passed to \code{get_formula()}}
}
\value{
\itemize{
\item \code{get_data()}: The data used to fit the model.
\item \code{get_response()}: The name of the response variable.
\item \code{get_offset_name()}: The name of the offset variable.
\item \code{get_weights()}: A list with \code{weights_name}, the name of the weighting
variable, and \code{weights}, the weights themselves (or all 1 when there are
no weights).
}
}
\description{
These functions get information and data from regression models.
}
