% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/re-import.R
\name{jst_combine_outputs}
\alias{jst_combine_outputs}
\title{Combine outputs from converted files}
\usage{
jst_combine_outputs(path, write_to_file = TRUE, out_path = NULL,
  overwrite = FALSE, clean_up = FALSE, warn = TRUE)
}
\arguments{
\item{path}{A path to a directory, containing .csv-files from
\code{\link[=jst_import]{jst_import()}} or \code{\link[=jst_import_zip]{jst_import_zip()}}, or a vector of files which are to be
imported.}

\item{write_to_file}{Should combined data be written to a file?}

\item{out_path}{A directory where to write the combined files. If no
directory is supplied and \code{write_to_file} is \code{TRUE}, the combined files are
written to \code{path}.}

\item{overwrite}{Should files be overwritten?}

\item{clean_up}{Do you want to remove the original batch files? Use with
caution.}

\item{warn}{Should warnings be raised, if the file type cannot be determined?}
}
\value{
Either writes to disk, or returns a list with all combined files.
}
\description{
\code{jst_combine_outputs()} helps you to manage the multitude of files you might
receive after running \code{\link[=jst_import]{jst_import()}} or \code{\link[=jst_import_zip]{jst_import_zip()}} with more than
one batch.
}
\details{
Splitting the output of \code{\link[=jst_import]{jst_import()}} or \code{\link[=jst_import_zip]{jst_import_zip()}} might be done
for multiple reasons, but in the end you possibly want to combine all outputs
into one file/data.frame. This function makes a few assumptions in order to
combine files:
\itemize{
\item Files with similar names (except for trailing dashes with numbers) belong
together and will be combined into one file.
\item The names of the combined files can be determined from the original files.
If you want to combine \code{foo-1.csv} and \code{foo-2.csv}, the combined file will
be \code{combined_foo.csv}.
\item The directory only contains files which were imported via
\code{\link[=jst_import]{jst_import()}} or \code{\link[=jst_import_zip]{jst_import_zip()}}. If the directory contains other
\code{.csv} files, you should supply a character vector with paths to only those
files, which you want to import.
}
}
\examples{
# set up a temporary directory
tmp <- tempdir()

# find multiple files
file_list <- rep(jst_example("sample_with_references.xml"), 2)

# convert and write to file
jst_import(file_list, "article", out_path = tmp, .f = jst_get_article,
             n_batches = 2, show_progress = FALSE)
             
# combine outputs
jst_combine_outputs(tmp)
list.files(tmp, "csv")

\dontrun{
# Trying to combine the files again raises an error.
jst_combine_outputs(tmp)
}

# this doesn't
jst_combine_outputs(tmp, overwrite = TRUE)

# we can remove the original files too
jst_combine_outputs(tmp, overwrite = TRUE, clean_up = TRUE)
list.files(tmp, "csv")

}
\seealso{
\code{\link[=jst_re_import]{jst_re_import()}}
}
