% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json_type.R
\name{json_type}
\alias{json_type}
\title{Query the JSON type}
\usage{
json_type(x, path = NULL)
}
\arguments{
\item{x}{A JSON vector}

\item{path}{Path to element. This must be a valid
\href{https://goessner.net/articles/JsonPath/index.html#e2}{JSONpath} expression.
For example \verb{"$.a.b[0]} extracts the \code{1} in \verb{\{"a": \{"b": [1, 2]\}\}}.}
}
\value{
A character vector of JSON types
}
\description{
The JSON types are
\itemize{
\item null
\item true, false
\item integer
\item real
\item array
\item object
}
}
\examples{
json_type(c(NA, "1", "null", "[1,2]", '{"a": 1}'))
}
