% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/solve-irr.R
\name{bisection.root}
\alias{bisection.root}
\title{Find zero of a function by bracketing the zero and then using
bisection.}
\usage{
bisection.root(f, guess, lower, upper, nstep = 100, toler = 1e-06)
}
\arguments{
\item{f}{The function whose zero is to be found. An R function
object that takes one numeric argument and returns a numeric
value. In an IRR application, this will be the NPV
function. In an implied volatility application, the value will
be the option price.}

\item{guess}{The starting value (guess) from which the solver
starts searching for the root. Must be positive.}

\item{lower}{The lower end of the interval within which to search
for the root. Must be positive.}

\item{upper}{The upper end of the interval within which to search
for the root. Must be positive.}

\item{nstep}{THe number of steps in the grid search to bracket the
zero. See details.}

\item{toler}{The criterion to determine whether a zero has been
found. This is passed on to \code{\link[stats]{uniroot}}}
}
\value{
The root (or NA if the method fails)
}
\description{
Tries to find the zero of a function by using the bisection method
(\code{\link[stats]{uniroot}}). To call
\code{\link[stats]{uniroot}}, the zero must be bracketed by
finding two points at which the function value has opposite
signs. The main code in this function is a grid search to find
such a pair of points. A geometric grid of points between
\code{lower} and \code{guess} and also between \code{guess} and
\code{upper}. This grid is searched for two neighbouring points
across which the function changes sign. This brackets the root,
and then we try to locate the root by calling
\code{\link[stats]{uniroot}}
}
\author{
Prof. Jayanth R. Varma
}

