% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jrc.R
\name{callFunction}
\alias{callFunction}
\title{Trigger a function call}
\usage{
callFunction(name, arguments = NULL, assignTo = NULL, thisArg = NULL,
  ...)
}
\arguments{
\item{name}{Name of the function. If the function is a method of some object
its name must contain the full chain of calls (e.g. \code{myArray.sort} or 
\code{Math.rand}).}

\item{arguments}{List of arguments for the function. Note that in JavaScript 
arguments must be given in a fixed order, naming is not necessary and will 
be ignored.}

\item{assignTo}{Name of a variable to which will be assigned the returned value
of the called function. If variable with this name doesn't exist, it will be added
to the currently active environment.}

\item{thisArg}{JavaScript functions (methods) can belong to some object, which 
is referred as \code{this} inside the function (e.g. in
\code{someObject.myFunction()} function \code{myFunction} is a method of \code{someObject}).
\code{thisArg} specified object that will be passed as \code{this} to the function. If \code{NULL}
then the function will be applied to the global object.}

\item{...}{further arguments passed to \code{\link{sendData}} that is used to send
\code{arguments} to the web server.}
}
\description{
Calls a function on the opened web page given its name and arguments.
JavaScript counterpart is \code{jrc.callFunction(name, arguments, assignTo, package)}, 
where the \code{package} argument allow to call function from some other
package. The result, however, will be anyway assigned to a variable in the
environment set by \code{\link{setEnvironment}}.
For security reasons, if function or variable to which its returned value
should be assigned are not in the lists of allowed functions and variables,
manual authorization of the call form JavaScript in the R session will be 
required. For more details check \code{\link{authorize}}.
}
\examples{
\donttest{
openPage()
callFunction("alert", list("Some alertText"))
callFunction("Math.random", assignTo = "randomNumber")
}

}
\seealso{
\code{\link{authorize}}, \code{\link{allowFunctions}}, \code{\link{allowVariables}},
\code{\link{setEnvironment}}.
}
