% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jpinfect_merge.R
\name{jpinfect_merge}
\alias{jpinfect_merge}
\title{Merge multiple disease datasets into a unified data table}
\usage{
jpinfect_merge(
  dataset1 = sex_prefecture,
  dataset2 = place_prefecture,
  dataset3 = NULL
)
}
\arguments{
\item{dataset1}{A data frame containing "sex" data to be merged.}

\item{dataset2}{A data frame containing "place" data to be merged.}

\item{dataset3}{(Optional) A third dataset containing "bullet" data to be added.}
}
\value{
A data frame that combines all input datasets and applies consistent column renaming.
}
\description{
This function merges multiple datasets (`dataset1`, `dataset2`, and optionally `dataset3`) based on shared columns: `prefecture`, `year`, and `week`.
It also renames column names according to the dataset type (`sex`, `place`, or `bullet`).
}
\examples{
\donttest{
# Example usage
bind_result <- jpinfect_merge(sex_prefecture, place_prefecture, bullet)
}

}
