% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_match_type}
\alias{check_match_type}
\title{Check match type consistency}
\usage{
check_match_type(x, y, by, match_type, verbose)
}
\arguments{
\item{x, y}{\code{data table}s. \code{y} is coerced to a \code{data.table} if
it isn't one already.}

\item{by}{A vector of shared column names in \code{x} and \code{y} to merge on.
This defaults to the shared key columns between the two tables.
If \code{y} has no key columns, this defaults to the key of \code{x}.}

\item{match_type}{character: one of \emph{"m:m"}, \emph{"m:1"}, \emph{"1:m"}, \emph{"1:1"}.
Default is \emph{"1:1"} since this the most restrictive. However, following
Stata's recommendation, it is better to be explicit and use any of the
other three match types (See details in \emph{match types sections}).}
}
\value{
character vector from \link{split_match_type}
}
\description{
This function checks if the match type chosen by the user is consistent with the data.
\if{html}{\out{<br>}}(Match type must be one of the valid types: "1:1", "1:m", "m:1", "m:m")
}
\examples{
\dontrun{
# Consistent match type
x1 = data.frame(
       id = c(1L, 1L, 2L, 3L, NA_integer_),
       t  = c(1L, 2L, 1L, 2L, NA_integer_),
       x  = 11:15)
y1 = data.frame(id = 1:2,
                y  = c(11L, 15L))
joyn:::check_match_type(x = x1, y=y1, by="id", match_type = "m:1")

# Inconsistent match type
joyn:::check_match_type(x = x1, y=y1, by="id", match_type = "1:1")
}
}
\keyword{internal}
