% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{JMfits2}
\alias{JMfits2}
\title{Study specific joint model fits using the JM package}
\format{A list of 5 \code{jointModel} objects, the result of fitting a joint
  model using the JM package to the data from each study in the \code{simDat}
  dataset in turn.}
\usage{
JMfits2
}
\description{
A dataset containing a list of the model fits for joint models fitted to the
data for each study in the \code{simdat} dataset using the JM package.
Further details of model fits supplied below.
}
\details{
These are the results of fitting a joint model using the \code{JM}
  package separately to the data from each study present in the \code{simdat}
  dataset.  This data has three levels, namely the longitudinal measurements
  at level 1, nested within individuals (level 2) who are themselves nested
  within studies (level 3). The joint models fitted to each study's data had
  the same format.  The longitudinal sub-model contained a fixed intercept,
  time and treatment assignment term, as well as a fixed time by treatment
  assignment interaction term, and random intercept and slope.  The survival
  sub-model contained a fixed treatment assignment term. The sub-models were
  linked by inserting both the current value of the longitudinal trajectory
  and its first derivative with respect to time into the survival sub-model.
  More formally, the longitudinal sub-model had the following format:

  \deqn{Y_{kij} = \beta_{10} + \beta_{11}time + \beta_{12}treat +
  \beta_{13}time*treat+ b^{(2)}_{0ki} + b^{(2)}_{1ki}time + \epsilon_{kij}}

  Where \eqn{Y} represents the continuous longitudinal outcome, fixed effect
  coefficients are represented by \eqn{\beta}, random effects coefficients by
  \eqn{b} and the measurement error by \eqn{\epsilon}.  For the  random
  effects the superscript of 2 indicates that these are individual level, or
  level 2 random effects.  This means they take can take a unique value for
  each individual in the dataset. The longitudinal time variable is
  represented by \eqn{time}, and the treatment assignment variable (a binary
  factor) is represented by \eqn{treat}.

  The survival sub-model had format:

  \deqn{\lambda_{ki}(t) = \lambda_{0}(t)exp(\beta_{21}treat +
  \alpha_{1}(\beta_{10} + \beta_{11}time + \beta_{12}treat + +
  \beta_{13}time*treat b^{(2)}_{0ki} + b^{(2)}_{1ki}time)+
  \alpha_{2}(\beta_{11} + \beta_{13}treat + b^{(2)}_{1ki})) }

  In the above equation, \eqn{\lambda_{ki}(t)} represents the survival time
  of the individual \eqn{i} in study \eqn{k}, and \eqn{\lambda_{0}(t)}
  represents the baseline hazard, which was modelled using splines. The fixed
  effect coefficient is represented by \eqn{\beta_{21}}.  Association
  parameters representing the link between the sub-models are represented by
  \eqn{\alpha} terms, where \eqn{\alpha_{1}} represents the effect of the
  current value of the longitudinal outcome on the risk of an event, whilst
  \eqn{\alpha_{2}} represents the effect of the slope, or rate of change of
  the longitudinal trajectory (the value of the first derivative of the
  longitudinal trajectory with respect to time) on the risk of an event.
  Again \eqn{treat} represents the binary facator treatment assignment
  variable, and \eqn{b^{(2)}_{0ki}} and \eqn{b^{(2)}_{1ki}} are the zero mean
  random effects from the longitudinal sub-model.

  We differentiate between the fixed effect coefficients in the longitudinal
  and the survival sub-models by varying the first number present in the
  subscript of the fixed effect, which takes a 1 for coefficients from the
  longitudinal sub-model and a 2 for coefficients from the survival
  sub-model.

  These fits have been provided in this package for use with the package
  vignette, see the vignette for more information.
}
\seealso{
\code{\link[JM]{jointModel}}, \code{\link[JM]{jointModelObject}}
}
\keyword{datasets}
