% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.dynSurv.R
\name{plot.dynSurv}
\alias{plot.dynSurv}
\title{Plot a \code{dynSurv} object}
\usage{
\method{plot}{dynSurv}(x, main = NULL, xlab = NULL, ylab1 = NULL,
  ylab2 = NULL, grid = TRUE, estimator, ...)
}
\arguments{
\item{x}{an object of class \code{dynSurv} calculated by the
\code{\link{dynSurv}} function.}

\item{main}{an overall title for the plot: see \code{\link[graphics]{title}}.}

\item{xlab}{a title for the x [time] axis: see \code{\link[graphics]{title}}.}

\item{ylab1}{a character vector of the titles for the \emph{K} longitudinal
outcomes y-axes: see \code{\link[graphics]{title}}.}

\item{ylab2}{a title for the event-time outcome axis: see
\code{\link[graphics]{title}}.}

\item{grid}{adds a rectangular grid to an existing plot: see
\code{\link[graphics]{grid}}.}

\item{estimator}{a character string that can take values \code{mean} or
\code{median} to specify what prediction statistic is plotted from an
objecting inheritting of class \code{dynSurv}. Default is
\code{estimator='median'}. This argument is ignored for non-simulated
\code{dynSurv} objects, i.e. those of \code{type='first-order'}, as in that
case a mode-based prediction is plotted.}

\item{...}{additional plotting arguments; currently limited to \code{lwd} and
\code{cex}. See \code{\link[graphics]{par}} for details.}
}
\value{
A dynamic prediction plot.
}
\description{
Plots the conditional time-to-event distribution for a
  \emph{new} subject calculated using the \code{\link{dynSurv}} function.
}
\examples{
\dontrun{
# Fit a joint model with bivariate longitudinal outcomes

data(heart.valve)
hvd <- heart.valve[!is.na(heart.valve$log.grad) & !is.na(heart.valve$log.lvmi), ]

fit2 <- mjoint(
    formLongFixed = list("grad" = log.grad ~ time + sex + hs,
                         "lvmi" = log.lvmi ~ time + sex),
    formLongRandom = list("grad" = ~ 1 | num,
                          "lvmi" = ~ time | num),
    formSurv = Surv(fuyrs, status) ~ age,
    data = list(hvd, hvd),
    inits = list("gamma" = c(0.11, 1.51, 0.80)),
    timeVar = "time",
    verbose = TRUE)

hvd2 <- droplevels(hvd[hvd$num == 1, ])
out1 <- dynSurv(fit2, hvd2)
plot(out1, main = "Patient 1")
}

\dontrun{
# Monte Carlo simulation with 95\% confidence intervals on plot

out2 <- dynSurv(fit2, hvd2, type = "simulated", M = 200)
plot(out2, main = "Patient 1")
}
}
\references{
Rizopoulos D. Dynamic predictions and prospective accuracy in joint models
for longitudinal and time-to-event data. \emph{Biometrics}. 2011;
\strong{67}: 819–829.
}
\seealso{
\code{\link{dynSurv}}
}
\author{
Graeme L. Hickey (\email{graeme.hickey@liverpool.ac.uk})
}
\keyword{hplot}
