#' Fitted \code{joint} object
#' 
#' @description An object returned by the \code{joint} function, inheriting from
#'   class \code{joint} and representing a fitted joint model for longitudinal
#'   and time-to-event (or competing risks) data.
#'   
#' @author Graeme L. Hickey (\email{graeme.hickey@@liverpool.ac.uk})
#' @keywords survival
#' @seealso \code{\link{joint}}.
#' @return A list with the following components. \describe{
#'   
#'   \item{\code{coefficients}}{a list with the estimated coefficients. The 
#'   components of this list are: \describe{
#'   
#'   \item{\code{fixed}}{longitudinal and survival sub-model fixed effects.}
#'   
#'   \item{\code{random}}{the BLUPs of the random effects.}
#'   
#'   \item{\code{latent}}{the latent association parameter(s) from the
#'   time-to-event sub-model.}
#'   
#'   }}
#'   
#'   \item{\code{sigama.z}}{a numeric double for the residual standard error.}
#'   
#'   \item{\code{sigma.u}}{the variance-covariance matrix of the random
#'   effects.}
#'   
#'   \item{\code{hazard}}{a vector of the (centered) baseline hazards at each
#'   unique failure time.}
#'   
#'   \item{\code{log.lik}}{the log-likelihood from the joint model fit and
#'   sub-model contributions.}
#'   
#'   \item{\code{numIter}}{the number of EM algorithm iterations.}
#'   
#'   \item{\code{convergence}}{a logical value of whether convergence was
#'   achieved or not.}
#'   
#'   \item{\code{model}}{see \code{\link{joint}} for details.}
#'   
#'   \item{\code{sepassoc}}{see \code{\link{joint}} for details.}
#'   
#'   \item{\code{sepests}}{see \code{\link{joint}} for details.}
#'   
#'   \item{\code{compRisk}}{a logical value indicating whether competing risks
#'   were detected or not.}
#'   
#'   \item{\code{sep.loglike}}{the log-likelihood from the joint model fit (with
#'   association set to zero) and separately fitted sub-model contributions.}
#'   
#'   \item{\code{formulae}}{a list of model formulae. See \code{\link{joint}}
#'   for details.}
#'   
#'   \item{\code{data}}{a \code{\link{jointdata}} object. See
#'   \code{\link{joint}} for details.}
#'   
#'   \item{\code{call}}{the model call. Can be used by
#'   \code{\link[stats]{update}}.}
#'   
#'   }
"joint.object" <- NULL
