% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{stringifyTerm}
\alias{stringifyTerm}
\title{Converts a term into a string}
\usage{
stringifyTerm(components, sep = getOption("jmvTermSep", ":"))
}
\arguments{
\item{components}{a character vector of components}

\item{sep}{a separator to go between the components}
}
\value{
the components joined together into a string for disply
}
\description{
Converts a term (a vector of components) into a string for display purposes
}
\examples{
stringifyTerm(c('a', 'b', 'c'))

# "a:b:c"

stringifyTerm(c('a', 'b', 'c'), sep=' * ')

# "a * b * c"

options('jmvTermSep', ' * ')
stringifyTerm(c('a', 'b', 'c'))

# "a * b * c"

#' stringifyTerm(c('`quoted`', 'b', 'c'))

# "quoted * b * c"

}

