% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{paa}
\alias{paa}
\title{Computes a Piecewise Aggregate Approximation (PAA) for a time series.}
\usage{
paa(ts, paa_num)
}
\arguments{
\item{ts}{a timeseries to compute the PAA for.}

\item{paa_num}{the desired PAA size.}
}
\description{
Computes a Piecewise Aggregate Approximation (PAA) for a time series.
}
\examples{
x = c(-1, -2, -1, 0, 2, 1, 1, 0)
x_paa3 = paa(x, 3)
#
plot(x, type = "l", main = c("8-points time series and its PAA transform into three points",
                          "PAA shown schematically in blue"))
points(x, pch = 16, lwd = 5)
#
paa_bounds = c(1, 1+7/3, 1+7/3*2, 8)
abline(v = paa_bounds, lty = 3, lwd = 2, col = "cornflowerblue")
segments(paa_bounds[1:3], x_paa3, paa_bounds[2:4], x_paa3, col = "cornflowerblue", lwd = 2)
points(x = c(1, 1+7/3, 1+7/3*2) + (7/3)/2, y = x_paa3, pch = 15, lwd = 5, col = "cornflowerblue")
}
\references{
Keogh, E., Chakrabarti, K., Pazzani, M., Mehrotra, S.,
Dimensionality reduction for fast similarity search in large time series databases.
Knowledge and information Systems, 3(3), 263-286. (2001)
}
