% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blsm.R
\name{blsm}
\alias{blsm}
\title{The Bipartite Latent Space Model}
\usage{
blsm(Niter, Y.ia, D)
}
\arguments{
\item{Niter}{number of iterations}

\item{Y.ia}{N by M matrix containing the binary multivariate attributes}

\item{D}{number of dimensions in the data}
}
\value{
list containing:
 \itemize{
 \item \code{lsmhEZ.i} (\code{N} x \code{D}) matrix containing the posterior means of the latent person positions
 \item \code{lsmhEZ.a} (\code{M} x \code{D}) matrix containing the posterior means of the latent item positions
 \item \code{lsmhVZ.0} (\code{D} x \code{D}) matrix containing the posterior variance of the latent person positions
 \item \code{lsmhVZ.1} (\code{D} x \code{D}) matrix containing the posterior variance of the latent item positions
 \item \code{lsmhAlpha.1} scaler of mean of the posterior distributions of \eqn{\alpha.1}
 \item \code{lsmhKL} expected log-likelihood
 }
}
\description{
Function to fit the bipartite latent space model (BLSM) outlined in Wang et al. (2021)
}
\examples{
attach(french)
a=blsm(Niter=10,Y.ia,D=2)
}
