% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annoRect.R
\name{annoRect}
\alias{annoRect}
\title{annoRect}
\arguments{
\item{object}{Your ggplot list. Default(NULL).}

\item{relSideDist}{The relative distance ratio to the y axis range. Default(0.1).}

\item{aesGroup}{Whether use your group column to add rect annotation. Default("FALSE").}

\item{aesGroName}{The mapping column name. Default(NULL).}

\item{annoPos}{The position for the annotation to be added. Default("top").}

\item{xPosition}{The x axis coordinate for the rect. Default(NULL).}

\item{yPosition}{The y axis coordinate for the rect. Default(NULL).}

\item{pCol}{The rect colors. Default(NULL).}

\item{pFill}{The rect fill colors. Default(NULL).}

\item{rectWidth}{The relative rect width. Default(1).}

\item{lty}{The rect line type. Default(NULL).}

\item{lwd}{The rect line width. Default(NULL).}

\item{alpha}{The rect fill color alpha. Default(NULL).}

\item{roundRect}{Whether add roundRect instead of rect. Default(FALSE).}

\item{roundRadius}{The roundRect corner radius. Default(0.1).}

\item{annoManual}{Whether annotate by yourself by supplying with x and y coordinates. Default(FALSE).}

\item{addText}{Whether add text label on segment. Default(FALSE).}

\item{textCol}{The text colors. Default(NULL).}

\item{textSize}{The text size. Default(NULL).}

\item{fontfamily}{The text fontfamily. Default(NULL).}

\item{fontface}{The text fontface. Default(NULL).}

\item{textLabel}{The text textLabel. Default(NULL).}

\item{textRot}{The text angle. Default(NULL).}

\item{textHVjust}{The text distance from the segment. Default(0.2).}

\item{hjust}{The text hjust. Default(NULL).}

\item{vjust}{The text vjust. Default(NULL).}

\item{textShift}{The text label shift size. Default(0).}

\item{rotateRect}{Whether to rotate the rect annotation. Default(FALSE).}

\item{normRectShift}{The "top" or "right" rotated rect shift. Default(0).}

\item{rotatedRectShift}{The "botomn" or "left" rotated rect shift. Default(1).}

\item{rectAngle}{Whether rotate the rect with specified degree. Default(NULL).}

\item{myFacetGrou}{Your facet group name to be added with annotation when object is a faceted object. Default(NULL).}

\item{aes_x}{= NULL You should supply the plot X mapping name when annotate a facetd plot. Default(NULL).}

\item{aes_y}{= NULL You should supply the plot Y mapping name when annotate a facetd plot. Default(NULL).}

\item{continuesRect}{Whether add gradient-color-rect. Default(FALSE).}

\item{border}{Whether add border for gradient-color-rect. Default(FALSE).}

\item{conRectCol}{The colors for gradient-color-rect. Default(NULL).}

\item{conRectColBin}{The colors numbers for gradient-color-rect. Default(10).}

\item{interpolate}{Whether blur the colors. Default(TRUE).}

\item{revColV}{Whether ajust the colors orders vertically. Default(FALSE).}

\item{revColH}{Whether ajust the colors orders horizontally. Default(FALSE).}
}
\value{
Return a ggplot object.
}
\description{
This function is used to add rect annotations in plot.
}
\examples{
# ===============================
# test function

# load data
data(p)
data(pgo)
data(pdotfc)

# default plot
annoRect(object = p,
         annoPos = 'top',
         xPosition = c(1:10))

# you can set y axis no expand
annoRect(object = p,
         annoPos = 'top',
         xPosition = c(1:10)) +
  ggplot2::scale_y_discrete(expand = c(0,0))

# adjust yPosition
annoRect(object = p,
         annoPos = 'top',
         xPosition = c(1:10),
         yPosition = c(11,11.5))

# another example annotation GO terms
annoRect(object = pgo,
        annoPos = 'right',
        yPosition = c(1:15),
        pCol = rep('transparent',15),
        pFill = rep(c('#F5F0BB','#C4DFAA','#90C8AC'),each = 5),
        xPosition = c(3,9.5),
        rectWidth = 1)
}
\author{
Junjun Lao
}
