% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/data.R
\name{getSearches}
\alias{getSearches}
\title{Get names of applied searches}
\usage{
getSearches(data, problem, filter, ...)
}
\arguments{
\item{data}{data object containing the analysis results}

\item{problem}{name of the analyzed problem. Can be omitted if the
\code{data} contains results for a single problem only.}

\item{filter}{\link{regular expression} (optional). Only search names that
match the given regex are returned, if any.}

\item{...}{any additional arguments are passed to \code{\link{grep}}.}
}
\value{
Sorted vector of strings containing the names of all searches that
  have been applied to the given problem and match the applied filter (if
  any).
}
\description{
Extracts the names of all searches that have been applied to the given
\code{problem}.This is a generic S3 method.
}
\details{
Search names are sorted using \link[naturalsort]{naturalsort}. If the
\code{data} contains results for a single problem only, the argument
\code{problem} can be omitted. If a \code{filter} is set, only those search
names matching the given \link{regular expression} are returned (pattern
matching is done with \code{\link{grep}}).
}

