% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-string.r
\name{formatInt}
\alias{formatInt}
\title{Format an integer as a string}
\usage{
formatInt(
  x,
  big.mark = ",",
  trim = TRUE,
  forceInteger = TRUE,
  scientific = FALSE,
  ...
)
}
\arguments{
\item{x}{\code{numeric} vector or matrix}

\item{big.mark, trim, scientific}{passed to \code{base::format()} but
configured with defaults intended for integer values:
\itemize{
\item \code{big.mark=","} adds comma between thousands.
\item \code{trim=TRUE} to trim excess whitespace.
\item \code{scientific=FALSE} to prevent exponential notation.
}}

\item{forceInteger}{\code{logical}, default TRUE, whether to round \code{numeric}
to \code{integer} prior to calling \code{base::format()}.}

\item{...}{Additional arguments are ignored.}
}
\value{
\code{character} vector if \code{x} is a vector, or if \code{x} is a matrix
a matrix will be returned.
}
\description{
Format an integer as a string
}
\details{
This function is a quick wrapper function around \code{base::format()}
to display integer values as text strings. It will also return a
matrix if the input is a matrix.
}
\examples{
x <- c(1234, 1234.56, 1234567.89);
## By default, commas are used for big.mark, and decimal values are hidden
formatInt(x);

## By default, commas are used for big.mark
formatInt(x, forceInteger=FALSE);

}
\seealso{
Other jam string functions: 
\code{\link{asSize}()},
\code{\link{breaksByVector}()},
\code{\link{fillBlanks}()},
\code{\link{gsubOrdered}()},
\code{\link{gsubs}()},
\code{\link{makeNames}()},
\code{\link{nameVector}()},
\code{\link{nameVectorN}()},
\code{\link{padInteger}()},
\code{\link{padString}()},
\code{\link{pasteByRow}()},
\code{\link{pasteByRowOrdered}()},
\code{\link{sizeAsNum}()},
\code{\link{tcount}()},
\code{\link{ucfirst}()}
}
\concept{jam string functions}
