% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars_functions.R
\name{vars_phylo}
\alias{vars_phylo}
\title{Create necessary information to create variants using phylogenetic tree(s)}
\usage{
vars_phylo(obj = NULL, fn = NULL)
}
\arguments{
\item{obj}{Object containing phylogenetic tree(s).
This can be (1) a single \code{phylo} object
that represents all sequences in the genome or
(2) a \code{list} or \code{multiPhylo} object containing a \code{phylo} object for
each reference sequence.
In the latter case, phylogenies will be assigned to sequences in the
order provided.
Defaults to \code{NULL}.}

\item{fn}{One or more string(s), each of which specifies the file name
of a NEWICK file containing a phylogeny.
If one name is provided, that phylogeny will be used for all sequences.
If more than one is provided, there must be a phylogeny for each reference
genome sequence, and phylogenies will be assigned to sequences
in the order provided.
Defaults to \code{NULL}.}
}
\value{
A \code{vars_phylo_info} object containing information used in \code{create_variants}
to create haploid variants.
This class is just a wrapper around a list containing phylogenetic tree
information for each reference sequence.
}
\description{
This function organizes higher-level information for creating variants from
phylogenetic tree(s) output as \code{phylo} or \code{multiPhylo} objects
(both from the \code{ape} package) or NEWICK files.
}
