% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/julia.R
\name{prettyForm}
\alias{prettyForm}
\title{Pretty exact expression}
\usage{
prettyForm(poly, asCharacter = FALSE)
}
\arguments{
\item{poly}{an \code{exactmvp} object, that is, a polynomial with an exact
expression}

\item{asCharacter}{Boolean, whether to return a character string; if
\code{FALSE}, the pretty form is printed}
}
\value{
A character string if \code{asCharacter=TRUE}, otherwise it is also
  returned but invisibly, and it is printed in the console.
}
\description{
Pretty form of the exact expression of a polynomial.
}
\examples{
library(jack)
\donttest{if(JuliaConnectoR::juliaSetupOk()){
  julia <- Jack_julia()
  ( pol <- julia$ZonalPol(m = 2, lambda = c(3, 1)) )
  prettyForm(pol)
  JuliaConnectoR::stopJulia()
}}
}
