% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivsacim.R
\name{summary.ivsacim}
\alias{summary.ivsacim}
\alias{print.summary.ivsacim}
\title{Summarizing Cumulative Intensity Function of Treatment with Instrumental Variables 
Estimation Using Structural Additive Cumulative Intensity Models}
\usage{
\method{summary}{ivsacim}(object, digits = 3, ...)

\method{print}{summary.ivsacim}(x, digits = 3, ...)
}
\arguments{
\item{object}{an object of class "ivsacim", usually, a result of a call to ivsacim.}

\item{digits}{number of digits we want to show}

\item{...}{further arguments passed to or from other methods.}

\item{x}{an object of class "summary.ivsacim", usually, a result of a call to summary.ivsacim.}
}
\value{
The function summary.ivsacim computes and returns a list of summary statistics of the fitted model given in object.
}
\description{
summary method for class "ivsacim".
}
\details{
print.summary.ivsacim tries to be smart about formatting coefficients, an estimated variance covariance matrix of
the coeffieients, Z-values and the corresponding P-values.
}
\examples{
n = 200
event = rbinom(n, 1, 0.8) 
IV = rbinom(n, 1, 0.5)
trt_init = IV
trt_shift = rep(0, n)
time = rexp(n)/(0.5 + trt_init * 0.2)
max_t = 3
max_t_bet = 3
n_sim = 0
fit <- ivsacim(time, event, IV, IV_valid = TRUE, trt_init, 
trt_shift, covar = NULL, max_t, max_t_bet, n_sim)
summary(fit)
}
