% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/between.R
\name{iv_pairwise_between}
\alias{iv_pairwise_between}
\title{Pairwise detect when a vector falls between an iv}
\usage{
iv_pairwise_between(x, y)
}
\arguments{
\item{x, y}{\verb{[vector, iv]}

\code{x} should be a vector and \code{y} should be an iv. \code{x} should have the same
type as the start/end components of \code{y}.

These will be recycled against each other.}
}
\value{
A logical vector the same size as the common size of \code{x} and \code{y}.
}
\description{
\code{iv_pairwise_between()} detects when \code{x}, a vector, falls between the
bounds of \code{y}, an iv, \emph{pairwise}, where pairwise means that the i-th value
of \code{x} is compared against the i-th interval of \code{y}. This is in contrast to
\code{\link[=iv_between]{iv_between()}}, which works more like \link[base:match]{base::\%in\%}.

These functions return a logical vector the same size as the common size of
\code{x} and \code{y}.
}
\examples{
x <- as.Date(c("2019-01-01", "2019-01-08", "2019-01-21"))

y <- iv_pairs(
  as.Date(c("2019-01-01", "2019-01-03")),
  as.Date(c("2019-01-07", "2019-01-09")),
  as.Date(c("2019-01-18", "2019-01-21"))
)

x
y

# Does the i-th value of `x` fall between the i-th interval of `y`?
iv_pairwise_between(x, y)

a <- c(1, NA, NA)
b <- iv_pairs(c(NA, NA), c(3, 4), c(NA, NA))

# Missing intervals always propagate
iv_pairwise_between(a, b)
}
\seealso{
\link[=relation-locate]{Locating relationships}

\link[=iv_locate_between]{Locating where a vector falls between an iv}

\link[=iv_between]{Detecting when a vector falls between an iv}
}
