% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lp.R
\name{optionsCplexAPI}
\alias{optionsCplexAPI}
\title{Function to parse options for CPLEX}
\usage{
optionsCplexAPI(options)
}
\arguments{
\item{options}{list. The name of each item must be the name of the
function to set the option, and is case sensitive. The value
assigned to each item is the value to set the option to. The
\code{env} argument should always be omitted. If the option
accepts a list of parameters, then these parameters should be
passed as using a named vector (e.g.
\code{list(setLogFileNameCPLEX = c(filename = "cpx.log", mode =
"w"))}).  If the function to set the option can be used
multiple times, then the value submitted should be a a list,
with each entry being a named vector
(e.g. \code{list(setDblParmCPLEX = list(c(parm = 1016, value =
1e-04), c(parm = 1084, value = 2)))}). If the option only
requires the \code{env} parameter, then an \code{NA} should be
passed as the parameter value (e.g. \code{list(setDefaultParm
= NA)}).}
}
\value{
list, each element being the command to evaluate to
    implement an option.
}
\description{
This function constructs a list of options to be parsed when
\code{lpsolver} is set to \code{cplexapi}.
}
