% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wweights.R
\name{negationCheck}
\alias{negationCheck}
\title{Check if custom weights are negations of each other}
\usage{
negationCheck(data, target.knots0, target.knots1, target.weight0,
  target.weight1, N = 20)
}
\arguments{
\item{data}{data set used for estimation. The comparisons are made
only on values in the support of the data set.}

\item{target.knots0}{user-defined set of functions defining the
knots associated with splines weights for the control
group. The arguments of the function should consist only of
variable names in \code{data}. If the knot is constant across
all observations, then the user can instead submit the value of
the weight instead of a function.}

\item{target.knots1}{user-defined set of functions defining the
knots associated with splines weights for the treated
group. The arguments of the function should be variable names
in \code{data}. If the knot is constant across all
observations, then the user can instead submit the value of the
weight instead of a function.}

\item{target.weight0}{user-defined weight function for the control
group defining the target parameter. A list of functions can be
submitted if the weighting function is in fact a spline. The
arguments of the function should be variable names in
\code{data}. If the weight is constant across all observations,
then the user can instead submit the value of the weight
instead of a function.}

\item{target.weight1}{user-defined weight function for the treated
group defining the target parameter. A list of functions can be
submitted if the weighting function is in fact a spline. The
arguments of the function should be variable names in
\code{data}. If the weight is constant across all observations,
then the user can instead submit the value of the weight
instead of a function.}

\item{N}{integer, default set to 20. This is the maxmimum number of
points between treated and control groups to compare and
determine whether or not the weights are indeed negations of
one another. If the data set contains fewer than \code{N}
unique values for a given set of variables, then all those
unique values are used for the comparison.}
}
\value{
boolean. If the weights are negations of each other,
    \code{TRUE} is returned.
}
\description{
This function checks whether the user-declared weights for treated
and control groups are in fact negations of each other. This is
problematic for the GMM procedure when accounting for estimation
error of the target weights.
}
