% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtr.R
\name{genGammaSplines}
\alias{genGammaSplines}
\title{Generate Gamma moments for splines}
\usage{
genGammaSplines(splinesobj, data, lb, ub, multiplier = 1, subset,
  d = NULL, means = TRUE, late.rows = NULL)
}
\arguments{
\item{splinesobj}{a list generated by \code{\link{removeSplines}}
applied to either the \code{m0} and \code{m1} argument.}

\item{data}{a \code{data.frame} object containing all the variables
that interact with the spline components.}

\item{lb}{vector of lower bounds for the interval of
integration. Each element corresponds to an observation.}

\item{ub}{vector of upper bounds for the interval of
integration. Each element corresponds to an observation.}

\item{multiplier}{a vector of the weights that enter into the
integral. Each element corresponds to an observation.}

\item{subset}{Subset condition used to select observations with
which to estimate gamma.}

\item{d}{either 0 or 1, indicating the treatment status.}

\item{means}{boolean, default set to \code{TRUE}. Set to
\code{TRUE} if estimates of the gamma moments should be
returned. Set to \code{FALSE} if the gamma estimates for each
observation should be returned.}

\item{late.rows}{Boolean vector indicating which observations to
include when conditioning on covariates X.}
}
\value{
a matrix, corresponding to the splines being integrated
    over the region specified by \code{lb} and \code{ub},
    accounting for the interaction terms. The number of rows is
    equal to the number of rows in \code{data}. The number of
    columns depends on the specifications of the spline. The name
    of each column takes the following form: "u[d]S[j].[b]", where
    "u" and "S" are fixed and stand for "unobservable" and
    "Splines" respectively. "[d]" will be either 0 or 1, depending
    on the treatment status. "[j]" will be an integer indicating
    which element of the list \code{splines} the column pertains
    to. "[b]" will be an integer reflect which component of the
    basis the column pertains to.
}
\description{
The user can declare that the unobservable enters into the MTRs in
the form of splines. This function generates the gamma moments for
the splines. The specifications for the spline must be passed as an
element generated by \code{\link{removeSplines}}. This function
accounts for the interaction between covariates and splines.
}
