% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/audit.R
\name{selectViolations}
\alias{selectViolations}
\title{Select points from audit grid to add to the constraint grid}
\usage{
selectViolations(diffVec, audit.add, lb0seq, lb1seq, lbteseq, ub0seq,
  ub1seq, ubteseq, mono0seq, mono1seq, monoteseq, mbmap)
}
\arguments{
\item{diffVec}{numeric vector, with a positive value indicating a
violation of a shape constriant.}

\item{audit.add}{integer, the number of points from the audit grid
to add to the intial for each constraint type. For instance, if
there are 5 different kinds of constraints imposed, and
\code{audit.add = 5}, then up to 30 points may be added to the
constraint grid.}

\item{lb0seq}{integer vector, indicates which rows in the audit
constraint matrix correspond to the lower bound for m0.}

\item{lb1seq}{integer vector, indicates which rows in the audit
constraint matrix correspond to the lower bound for m1.}

\item{lbteseq}{integer vector, indicates which rows in the audit
constriant matrix correspond to the lower bound for the
treatment effect.}

\item{ub0seq}{integer vector, indicates which rows in the audit
constraint matrix correspond to the upper bound for m0.}

\item{ub1seq}{integer vector, indicates which rows in the audit
constraint matrix correspond to the upper bound for m1.}

\item{ubteseq}{integer vector, indicates which rows in the audit
constriant matrix correspond to the upper bound for the
treatment effect.}

\item{mono0seq}{integer matrix, indicates which rows in the audit
constraint matrix correspond to the monotonicity conditions for
m0, and whether the constriant is increasing (+1) or decreasing
(-1).}

\item{mono1seq}{integer matrix, indicates which rows in the audit
constraint matrix correspond to the monotonicity conditions for
m1, and whether the constriant is increasing (+1) or decreasing
(-1).}

\item{monoteseq}{integer matrix, indicates which rows in the audit
constraint matrix correspond to the monotonicity conditions for
the treatment effect, and whether the constriant is increasing
(+1) or decreasing (-1).}

\item{mbmap}{integer vector, indexes the X-value associated with
each row in the audit constraint matrix.}
}
\value{
The audit grid is represented using a set of constraint
    matrices. Each point in the audit grid corresponds to a set of
    rows in the constraint matrices. The function simply returns
    the vector of row numbers for the points from the audit grid
    whose corresponding constriants should be added to the original
    LP problem (i.e. the points to add to the original grid).
}
\description{
This function selects which points from the audit grid should be
included into the original grid. Both the constraint grid and audit
grid are represented as constraints in an LP problem. This function
selects which points in the audit grid (i.e. which rows in the
audit constraint matrix) should be added to the constraint grid
(i.e. should be appended to the constraint matrix).
}
