#' LiDAR data point cloud acquired over a forest area
#'
#' A dataset containing the X Y Z coordinates of LiDAR points acquired over a forest area. The EPSG code of the coordinates is 32632.
#'
#' \itemize{
#'   \item X. X coordinate in UTM WGS84 32 N (EPSG code 32632).
#'   \item Y. Y coordinate in UTM WGS84 32 N (EPSG code 32632).
#'   \item Z. Z coordinate. The Z coordinate is normalized respect to the ground.
#' }
#'
#' @docType data
#' @keywords datasets
#' @name lasData
#' @usage data(lasData)
#' @format A data frame with 16907 rows and 3 variables
"lasData"
