% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itan.R
\name{pBis}
\alias{pBis}
\title{Correlaci\enc{ó}{o}n biserial puntual.}
\usage{
pBis(respuestas, clave, correccionPje = TRUE, nOpciones = 4, digitos = 2)
}
\arguments{
\item{respuestas}{Una matriz con las alternativas seleccionadas por los estudiantes
a cada \enc{í}{i}tem de la prueba.}

\item{clave}{Una hoja de datos con la alternativa correcta para cada \enc{í}{i}tem.}

\item{correccionPje}{Un valor l\enc{ó}{o}gico para usar o no la correcci\enc{ó}{o}n de puntaje.
La correcci\enc{ó}{o}n de puntaje consiste en restar del puntaje total obtenido en la prueba
el punto obtenido por el \enc{í}{i}tem analizado.}

\item{nOpciones}{La cantidad de alternativas posibles para cada \enc{í}{i}tem.}

\item{digitos}{La cantidad de d\enc{í}{i}gitos significativos que tendr\enc{á}{a} el resultado.}
}
\value{
Una hoja de datos con la correlaci\enc{ó}{o}n biserial puntual de las alternativas
y la alternativa correcta para cada \enc{í}{i}tems.
}
\description{
Calcula la correlaci\enc{ó}{o}n biserial puntual para cada alternativa de cada \enc{í}{i}tem con respecto
al puntaje obtenido en la prueba.
}
\examples{
data(datos)
data(clave)
respuestas <- subset(datos, select = -id)
pBis(respuestas, clave)

}
\seealso{
\code{\link{analizarDistractores}}, \code{\link{frecuenciaDistractores}}
y \code{\link{analizarItems}}.
}
