% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/units.R
\name{iso_format}
\alias{iso_format}
\title{Format values}
\usage{
iso_format(
  ...,
  signif = 3,
  format_names = "\%s: ",
  format_units = "\%s",
  replace_permil = TRUE,
  sep = "\\n"
)
}
\arguments{
\item{...}{variable names with data. Must have the same dimensions if multiple are supplied. Can be named to rename variable name output. Will include units in output for all \link{iso_with_units}.}

\item{signif}{number of significant digits for numbered data}

\item{format_names}{how to format the variable names, set to \code{NULL} to remove names}

\item{format_units}{how to format the units from \code{\link{iso_double_with_units}} variables, set to \code{NULL} to omit units}

\item{replace_permil}{whether to replace the term 'permil' with the permil symbol (\\u2030)}

\item{sep}{separator between variables if multiple are provided in \code{...}}
}
\description{
Convenience function to easily format and concatenate text and numeric values. Can be used with any test and number data. Automatically detects \code{\link{iso_with_units}} values and incorporates the units into the formatting.
}
\examples{
x <- iso_with_units(1:5, "V")
y <- iso_with_units(1:5, "permil")
iso_format(x, y)
iso_format(amplitude = x, d13C = y)
}
