% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a18_c_H2O.R
\name{a18_c_H2O}
\alias{a18_c_H2O}
\title{18O/16O fractionation factor between carbonate and water}
\usage{
a18_c_H2O(temp, min, eq)
}
\arguments{
\item{temp}{Carbonate growth temperature (°C).}

\item{min}{Mineralogy. Options are \code{"calcite"}, \code{"aragonite"},
\code{apatite}, \code{siderite}, and \code{"dolomite"}.}

\item{eq}{Equation used for the calculations. See details.}
}
\value{
Returns the 18O/16O fractionation factor.
}
\description{
\code{a18_c_H2O()} calculates the 18O/16O fractionation factor
between carbonate and water.
}
\details{
Options for eq if min = \code{"calcite"}:

\code{"ONeil69"}: O'Neil et al. (1969), modified by Friedman and O'Neil (1977):

\deqn{\alpha^{18}_{calcite/water} =
e^{(2.78 \times \frac{1000}{T^{2}} - 0.00289)}}

\code{"KO97-orig"}: Kim and O'Neil (1997):

\deqn{\alpha^{18}_{calcite/water} =
e^{(18.03 \times \frac{1}{T} - 0.03242)}}

\strong{NOTE:} The "KO97-orig" equation should only be applied to data that considers a
CO2(acid)/calcite AFF as in Kim & O'Neil (1997), i.e., 10.44 at 25 °C.

\code{"KO97"}: Kim and O'Neil (1997), reprocessed here to match the IUPAC-recommended
AFF as in Kim et al. (2007, 2015):

\deqn{\alpha^{18}_{calcite/water} =
e^{(18.04 \times \frac{1}{T} - 0.03218)}}

\code{"Coplen07"}: Coplen (2007):

\deqn{\alpha^{18}_{calcite/water} =
e^{(17.4 \times \frac{1}{T} - 0.0286)}}

\code{"Tremaine11"}: Tremaine et al. (2011):

\deqn{\alpha^{18}_{calcite/water} =
e^{(16.1 \times \frac{1}{T} - 0.0246)}}

\code{"Watkins13"}: Watkins et al. (2013):

\deqn{\alpha^{18}_{calcite/water} =
e^{(17.747 \times \frac{1}{T} - 0.029777)}}

\code{"Daeron19"}: Daëron et al. (2019):

\deqn{\alpha^{18}_{calcite/water} =
e^{(17.57 \times \frac{1}{T} - 0.02913)}}

Options for eq if min = \code{"aragonite"}:

\code{"GK86"}: Grossman and Ku (1986), modified by Dettman et al. (1999):

\deqn{\alpha^{18}_{aragonite/water} =
e^{(2.559 \times \frac{1000}{T^{2}} + 0.000715)}}

\code{"Kim07"}: Kim et al. (2007):

\deqn{\alpha^{18}_{aragonite/water} =
e^{(17.88 \times \frac{1}{T} - 0.03114)}}

Options for eq if min = \code{"apatite"}.
Apatite refers to apatite-bound carbonate.

\code{"Lecuyer10"}: Lécuyer et al. (2010):

\deqn{\alpha^{18}_{apatite/water} =
e^{(25.19 \times \frac{1}{T} - 0.05647)}}

Options for eq if min = \code{"siderite"}:

\code{"vanDijk18"}: van Dijk et al. (2018):

\deqn{\alpha^{18}_{siderite/water} =
e^{(19.67 \times \frac{1}{T} - 0.03627)}}

Options for eq if min = \code{"dolomite"}:

\code{"Vasconcelos05"}: Vasconcelos et al. (2005):

\deqn{\alpha^{18}_{dolomite/water} =
e^{(2.73 \times \frac{1000}{T^{2}} + 0.00026)}}
}
\examples{
a18_c_H2O(temp = 25, min = "calcite", eq = "Coplen07")
a18_c_H2O(temp = 25, min = "aragonite", "GK86")

}
\references{
O'Neil, J. R., Clayton, R. N., & Mayeda, T. K. (1969).
Oxygen isotope fractionation in divalent metal carbonates.
The Journal of Chemical Physics, 51(12), 5547-5558.
\doi{10.1063/1.1671982}

Grossman, E. L., & Ku, T. L. (1986).
Oxygen and carbon isotope fractionation in biogenic
aragonite: Temperature effects.
Chemical Geology, 59(1), 59-74.
\doi{10.1016/0009-2541(86)90044-6}

Kim, S.-T., & O'Neil, J. R. (1997).
Equilibrium and nonequilibrium oxygen isotope effects
in synthetic carbonates.
Geochimica et Cosmochimica Acta, 61(16), 3461-3475.
\doi{10.1016/S0016-7037(97)00169-5}

Dettman, D. L., Reische, A. K., & Lohmann, K. C. (1999).
Controls on the stable isotope composition of seasonal growth bands
in aragonitic fresh-water bivalves (unionidae).
Geochimica et Cosmochimica Acta, 63(7-8), 1049-1057.
\doi{10.1016/s0016-7037(99)00020-4}

Vasconcelos, C., McKenzie, J. A., Warthmann, R.,
& Bernasconi, S. M. (2005).
Calibration of the d18O paleothermometer for dolomite precipitated in
microbial cultures and natural environments.
Geology, 33(4), 317-320.
\doi{10.1130/g20992.1}

Kim, S.-T., Mucci, A., & Taylor, B. E. (2007).
Phosphoric acid fractionation factors for calcite and aragonite between
25 and 75 °C: Revisited. Chemical Geology, 246(3-4), 135-146.
\doi{10.1016/j.chemgeo.2007.08.005}

Coplen, T. B. (2007).
Calibration of the calcite–water oxygen-isotope geothermometer
at Devils Hole, Nevada, a natural laboratory.
Geochimica et Cosmochimica Acta, 71(16), 3948-3957.
\doi{10.1016/j.gca.2007.05.028}

Lécuyer, C., Balter, V., Martineau, F., Fourel, F., Bernard, A.,
Amiot, R., et al. (2010).
Oxygen isotope fractionation between apatite-bound carbonate
and water determined from controlled experiments with synthetic
apatites precipitated at 10–37°C.
Geochimica et Cosmochimica Acta, 74(7), 2072-2081.
\doi{10.1016/j.gca.2009.12.024}

Tremaine, D. M., Froelich, P. N., & Wang, Y. (2011).
Speleothem calcite farmed in situ: Modern calibration of d18O and d13C
paleoclimate proxies in a continuously-monitored natural cave system.
Geochimica et Cosmochimica Acta, 75(17), 4929-4950.
\doi{10.1016/j.gca.2011.06.005}

Watkins, J. M., Nielsen, L. C., Ryerson, F. J., & DePaolo, D. J. (2013).
The influence of kinetics on the oxygen isotope composition
of calcium carbonate.
Earth and Planetary Science Letters, 375, 349-360.
\doi{10.1016/j.epsl.2013.05.054}

van Dijk, J., Fernandez, A., Müller, I. A., Lever, M., & Bernasconi, S.
M. (2018).
Oxygen isotope fractionation in the siderite-water system between 8.5
and 62 °C.
Geochimica et Cosmochimica Acta, 220, 535-551.
\doi{10.1016/j.gca.2017.10.009}

Daëron, M., Drysdale, R. N., Peral, M., Huyghe, D., Blamart, D.,
Coplen, T. B., et al. (2019).
Most Earth-surface calcites precipitate out of isotopic equilibrium.
Nature Communications, 10, 429.
\doi{10.1038/s41467-019-08336-5}
}
\seealso{
Other fractionation_factors: 
\code{\link{a13_CO2g_CO2aq}()},
\code{\link{a18_CO2acid_c}()},
\code{\link{a18_CO2aq_H2O}()},
\code{\link{a18_CO2g_H2O}()},
\code{\link{a18_CO3_H2O}()},
\code{\link{a18_H2O_OH}()},
\code{\link{a18_HCO3_H2O}()},
\code{\link{a_A_B}()}
}
\concept{fractionation_factors}
