% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeQuantileSurface.R
\name{makeQuantileSurfaces}
\alias{makeQuantileSurfaces}
\title{Convert probability surface to probability-quantile surface}
\usage{
makeQuantileSurfaces(probabilitySurface, rename = FALSE)
}
\arguments{
\item{probabilitySurface}{Normalized probability surface RasterLayer}

\item{rename}{Character value to append to raster name (e.g. "_quantile"). Defaults to FALSE.}
}
\value{
Returns RasterLayer rescaled to quantile values.
}
\description{
Converts normalized probability surface (e.g. one layer output of
isotopeAssignmentModel function) to quantile surfaces.
}
\examples{
# Generate example probability surfaces.
myiso <- rasterFromXYZ(isoscape)
myiso_sd <- rasterFromXYZ(isoscape_sd)
df <- data.frame(
         ID = c(-100, -80, -50),
         isotopeValue = c(-100, -80, -50),
         SD_indv = rep(5, 3)
         )
assignmentModels <- isotopeAssignmentModel(
         ID = df$ID,
         isotopeValue = df$isotopeValue,
         SD_indv = df$SD_indv,
         precip_raster = myiso,
         precip_SD_raster = myiso_sd,
         nClusters = FALSE
         )

# Convert to quantile surfaces.
quantile_surface <-  raster::stack( lapply( unstack(assignmentModels), makeQuantileSurfaces) )
plot(quantile_surface)

}
