% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_sweepers.R
\name{sweep_dyn}
\alias{sweep_dyn}
\title{Sweep the space of two parameters during a dynamic run}
\usage{
sweep_dyn(
  workdir,
  SERIES_ID,
  time_units,
  EXPLO_MASTER,
  EXPLO_AXIS_1,
  EXPLO_AXIS_2,
  to_DYN_DIGEST_CSVs = FALSE,
  plot_results = TRUE,
  save_run_outputs = FALSE
)
}
\arguments{
\item{workdir}{Working directory of \strong{\emph{0_ISOBXR_MASTER.xlsx}} master file, \cr
of the dynamic sweep master file (e.g., \strong{\emph{0_EXPLO_DYN_MASTER.xlsx}}) \cr
and where output files will be stored if saved by user. \cr
(character string)}

\item{SERIES_ID}{Name of the sweep series the run belongs to. \cr
It determines the folder in which the output files will be stored for this sweep run.\cr
A sweep run number is automatically linked to it,
and subsequent sweep runs can not overwrite a previous one.\cr
(character string)}

\item{time_units}{Vector defining the initial time unit
(identical to unit used in fluxes), \cr
followed by the time unit used for the graphical output.\cr
Character string, to be selected  among the following:\cr
\emph{micros, ms, s, min, h, d, wk, mo, yr, kyr, Myr, Gyr}\cr
e.g.,  c("d", "yr") to convert days into years}

\item{EXPLO_MASTER}{Name of the dynamic sweep master file (e.g., \strong{\emph{0_EXPLO_DYN_MASTER.xlsx}}),
defining the dynamic sweep run scenario. \cr
(character string)}

\item{EXPLO_AXIS_1}{Set of values of sweeping parameter 1. \cr
See Vignette for further details.}

\item{EXPLO_AXIS_2}{Set of values of sweeping parameter 2. \cr
See Vignette for further details.}

\item{to_DYN_DIGEST_CSVs}{\emph{OPTIONAL} \cr
Logical value. \cr
Exports all global csv outputs to \strong{\emph{0_DYN_DIGEST}} folder (full evD and evS) if TRUE. \cr
Default is FALSE.}

\item{plot_results}{\emph{OPTIONAL} \cr
Logical value. \cr
If TRUE, plots in R session the evolution of deltas as a function of time with respect to parameters 1 and 2,
for all system finite boxes. \cr
Default is TRUE.}

\item{save_run_outputs}{\emph{OPTIONAL} \cr
Logical value. \cr
Allows saving all run outputs to working directory (workdir). \cr
By default, run outputs are stored in the temporary directory and are erased if not saved. \cr
Default is FALSE.}
}
\value{
Calculates the delta values and box sizes at final state of the sweeping of 2D space of parameters in all boxes.

\code{\link{sweep_dyn}} returns by default a plot showing time evolution of delta values of the isotope composition
of each finite box in the 2D space defined by the two swept parameters
(set plot_results = FALSE to mute the plots). \cr

The graphical results of the sweep can be also interactively explored using the
\code{\link{shinobxr_app}} function in case user saves the outputs to the working
directory (save_run_outputs = TRUE).

\code{\link{sweep_steady}} creates a series of isotope data and metadata,
all of which are stored in a temporary directory. \cr
The user can save all outputs described below to their working directory
by setting save_run_outputs = TRUE (default is FALSE). \cr

\code{\link{sweep_dyn}} creates and stores all outputs in a dedicated SERIES directory
with the following name structure: \cr
\strong{\emph{4_DYN + SERIES_ID + YYY}}, where YYY is a sweep dynamic run number automatically set between 001 and 999. \cr
No overwriting of previous sweep dynamic run runs is possible.

\code{\link{sweep_steady}} base workflow:
\enumerate{
\item Calculates the number of single runs the sweeping will require depending on the swept parameters.
\item Asks the user confirmation to run \code{\link{sweep_dyn}},
as the run calculation time depends on the number of successive sweeping runs.
\item Writes the set of inputs and outputs for all successive \emph{n} sweeping runs, numbered from to 1 to \emph{n} in an XXXX format,
with the following name formats: \cr
\strong{\emph{DYN + SERIES_ID + YYY + XXXX + IN.Rda}} \cr
\strong{\emph{DYN + SERIES_ID + YYY + XXXX + OUT.Rda}} \cr
(see \code{\link{run_isobxr}} documentation).

\item Writes summarized results in the  \strong{\emph{0_DYN_DIGEST}} folder:
\enumerate{
\item Archived LOG file of local sweep dynamic run. \cr
(file name structure:  \strong{\emph{DYN + SERIES_ID + YYY + _LOG.csv}})
\item Archived sweep dynamic master file. \cr
(file name structure:  \strong{\emph{DYN + SERIES_ID + YYY + _MASTER.xlsx}})
\item Dataset of temporal evolution of delta values (evD) in all boxes over the \emph{n} runs that constitute the sweep dynamic run. \cr
(file name structure: \strong{\emph{DYN + SERIES_ID + YYY + evD.RDS}})
\item Dataset of temporal evolution of box sizes (evS, masses of X) in all boxes over the \emph{n} runs that constitute the sweep dynamic run. \cr
(file name structure: \strong{\emph{DYN + SERIES_ID + YYY + evS.RDS}})
}
}
}
\description{
A function to assess the influence of two parameters (varying
over a range of values) on dynamic evolution of a given model in response to a given perturbation.
}
\section{Optional output}{

\enumerate{
\item If to_DYN_DIGEST_CSVs = TRUE \cr
In the \strong{\emph{0_DYN_DIGEST}} folder,
edits csv versions of the sweep dynamic run datasets (full evD and evS) with the following name structures:
\enumerate{
\item \strong{\emph{DYN + SERIES_ID + YYY + evD.csv}}
\item \strong{\emph{DYN + SERIES_ID + YYY + evS.csv}}
}
}
For examples, see
https://ttacail.github.io/isobxr_web/vgn_08_sweep_dyn.html#4_Tutorial_example
}

