% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-doc.R
\docType{data}
\name{diabetes}
\alias{diabetes}
\title{Blood and other measurements in diabetics}
\format{
A data frame with 442 rows and 3 columns:
\describe{
  \item{x}{Matrix with 10 numeric columns (standardized)}
  \item{y}{Numeric response vector}
  \item{x2}{Matrix with 64 columns including interactions}
}
}
\source{
\url{https://web.stanford.edu/~hastie/Papers/LARS/LeastAngle_2002.ps}
}
\description{
The \code{diabetes} data frame contains 442 observations used in the Efron et al. "Least Angle Regression" paper.
}
\details{
The \code{x} matrix has been standardized to have unit L2 norm and zero mean in each column.
The \code{x2} matrix extends \code{x} by adding selected interaction terms.
}
\examples{
data(diabetes)
str(diabetes)
summary(diabetes$y)

\dontrun{
  fit <- islasso(y ~ ., data = data.frame(y = diabetes$y, diabetes$x2),
                 family = gaussian())
  summary(fit, pval = 0.05)
  lambda.aic <- aic.islasso(fit, interval = c(1, 100))
  fit.aic <- update(fit, lambda = lambda.aic)
  summary(fit.aic, pval = 0.05)
}

}
\references{
Efron, Hastie, Johnstone and Tibshirani (2003). "Least Angle Regression" (with discussion), \emph{Annals of Statistics}.
}
\keyword{datasets}
