% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_resp_loglik.R
\name{plot_resp_loglik}
\alias{plot_resp_loglik}
\title{Plot the Log-Likelihood of a response string}
\usage{
plot_resp_loglik(
  ip,
  resp,
  theta_range = c(-5, 5),
  title = "",
  likelihood = FALSE,
  show_estimate = TRUE,
  base_r_graph = FALSE,
  suppress_plot = FALSE,
  text_size = 12,
  ...
)
}
\arguments{
\item{ip}{An \code{\link{Itempool-class}} class object.}

\item{resp}{The response string or a \code{\link{Response-class}} class
object.}

\item{theta_range}{Either (a) a numeric vector of length two where the values
are minimum and maximum theta values, or, (b) a numeric vector of length
more than two where values represents the theta values that will be
plotted.}

\item{title}{Title of the Plot}

\item{likelihood}{If \code{TRUE}, likelihood function will be plotted
instead of log-likelihood graph. Default value is \code{FALSE}.}

\item{show_estimate}{If \code{TRUE} the maximum likelihood ability estimate
will be shown. The default value is \code{TRUE}.}

\item{base_r_graph}{If \code{TRUE} function will plot graphs using base R
graphics. If \code{FALSE} the function will check whether 'ggplot2' package
is installed. If it is installed, it will use 'ggplot2' package for the
plot. The default value is \code{FALSE}.}

\item{suppress_plot}{If \code{FALSE} the function will print the plot. If
\code{TRUE}, function will return the plot object. Default value is
\code{FALSE}.}

\item{text_size}{The overall text size of the axis and titles. The default
value is 12.}

\item{...}{Additional arguments passed to annotate.}
}
\value{
Depending on the value of \code{suppress_plot} function either prints
the Log-likelihood function of the response string or returns the plot
object.
}
\description{
\code{plot_resp_loglik} plots the log-likelihood of a response string.
}
\section{To-do}{

\itemize{
\item Make it to plot multiple test information functions. You can input a
list each of which contains item parameters. And the name of the test also.
}
}

\examples{
ip <- generate_ip(n = 9)
resp_set <- generate_resp_set(ip = ip, theta = rnorm(10))

# Plot second item's response log-likelihood function
plot_resp_loglik(ip, resp_set[[2]])

# Plot response likelihood function of second item
plot_resp_loglik(ip, resp_set[[2]], likelihood = TRUE)

# Plot using base r graphics
plot_resp_loglik(ip, resp_set[[2]], likelihood = TRUE, base_r_graph = TRUE)

# Suppress the MLE estimate
plot_resp_loglik(ip, resp_set[[4]], show_estimate = FALSE)

}
\author{
Emre Gonulates
}
