% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itempool-class-methods.R,
%   R/response_set-class-methods.R
\name{c,Item-method}
\alias{c,Item-method}
\alias{c,Itempool-method}
\alias{c,Testlet-method}
\alias{c,Response-method}
\alias{c,Response_set-method}
\title{Concatenate \code{Item}, \code{Itempool} or \code{Testlet} objects and
return an Itempool object.}
\usage{
\S4method{c}{Item}(x, ...)

\S4method{c}{Itempool}(x, ...)

\S4method{c}{Testlet}(x, ...)

\S4method{c}{Response}(x, ...)

\S4method{c}{Response_set}(x, ...)
}
\arguments{
\item{x}{A list consist of \code{\link{Response-class}} or
\code{\link{Response_set-class}} objects.}

\item{...}{Additional arguments}
}
\value{
An \code{\link{Itempool-class}} object.

A \code{\link{Response_set-class}} object.
}
\description{
If the elements do not have ID fields, function will assign default names.

This function concatenates \code{Response} and/or
  \code{Response_set} objects and returns a \code{\link{Response_set-class}}
  object.

If the elements do not have examinee ID fields, function will assign
default ids.
}
\examples{
item1 <- item(a = 1.12, b = -2.1, c = 0.28)
item2 <- item(a = 2, b = 3.2, c = 0.21)

# Concatenate items
c(item1, item2)

ip <- itempool(a = c(1, 1.2), b = c(1, 2), c = c(.2, .4))
# Concatenate items and an Itempool object
c(item1, ip)
c(item1, item2, ip)
c(ip, item1, item2)
}
\author{
Emre Gonulates

Emre Gonulates
}
