% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response-class-methods.R
\name{as.data.frame.Response}
\alias{as.data.frame.Response}
\title{Convert a \code{\link{Response-class}} object into a \code{data.frame}.}
\usage{
\method{as.data.frame}{Response}(
  x,
  row.names = NULL,
  optional = FALSE,
  ...,
  attach_unique_misc = TRUE
)
}
\arguments{
\item{x}{An \code{\link{Response-class}} object}

\item{row.names}{\code{NULL} or a character vector giving the row names for
the data frame. Missing values are not allowed.}

\item{optional}{logical. If \code{TRUE}, setting row names and converting
column names}

\item{...}{additional arguments}

\item{attach_unique_misc}{If \code{TRUE}, the elements of the \code{misc}
slot that have lengths one will be attached to the data frame returned.
The default is \code{TRUE}.}
}
\value{
A data frame of item_ids/responses/scores within each row.
}
\description{
This function converts \code{\link{Response-class}} objects to a
  \code{data.frame} object.
}
\examples{

resp <- response(examinee_id = "Stu12",
                 item_id = c("Item1", "Item2", "Item3", "Item4"),
                 score = c(0, 1, 1, 1),
                 raw_response = c("B", "A", "D", "Right Angle"),
                 order = c(1L, 2L, 3L, 4L),
                 misc = list(item_role = c("F", "O", "O", "O"),
                             lexile_level = c(1, 4, 3, 1),
                             item_type = c("MC", "MC", "MS", "SA"),
                             test_date = as.Date("2021-11-21"),
                             Form = "Test Form 001",
                             theta = 2.2))
as.data.frame(resp)

# Do not include misc fields whose lengths are not equal to the number of
# items
as.data.frame(resp, attach_unique_misc = FALSE)

}
\author{
Emre Gonulates
}
