% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_IRT.R
\name{plot_info}
\alias{plot_info}
\title{Plot Item Information Function}
\usage{
plot_info(
  ip,
  tif = FALSE,
  theta_range = c(-5, 5),
  title = "",
  suppress_plot = FALSE,
  ...
)
}
\arguments{
\item{ip}{An \code{\link{Item-class}} or \code{\link{Itempool-class}}
object.}

\item{tif}{If \code{TRUE} a test information plot will be plotted. The
default value is \code{FALSE}.}

\item{theta_range}{The boundaries of x axis.}

\item{title}{Title of the plot}

\item{suppress_plot}{If \code{FALSE} the function will print the plot. If
\code{TRUE}, function will return the plot object. Default value is
\code{FALSE}.}

\item{...}{Extra parameters that will pass to \code{geom_line}.}
}
\value{
Depending on the value of \code{suppress_plot} function either prints
the item information function or returns the plot object.
}
\description{
\code{plot_info} Plots the item information function.
}
\examples{
# Plot the information function of an item
plot_info(item(b = 1))

# Plot information function(s) of an Itempool object
n <- sample(10:20,1)
ip <- itempool(data.frame(a = runif(n, .5, 2), b = rnorm(n),
                             c = runif(n, 0, .3), D = 1))
plot_info(ip)
plot_info(ip, tif = TRUE)
}
\author{
Emre Gonulates
}
