% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_example.R
\name{use_example_ee_script}
\alias{use_example_ee_script}
\title{Use an example sampling script for Earth Engine}
\usage{
use_example_ee_script(sensor = "MODIS", filename = NULL, overwrite = FALSE)
}
\arguments{
\item{sensor}{either 'MODIS' or 'Landsat'}

\item{filename}{file name indicating where to save the example script.
Default is './Sample-NDVI-For-IRG-MODIS.js' if sensor is 'MODIS' or
'Sample-NDVI-For-IRG-Landsat.js' if sensor is 'Landsat'.}

\item{overwrite}{boolean indicating if the file should overwrite existing
files. default is FALSE.}
}
\value{
\code{use_example_ee_script} saves an example NDVI extraction script in the
current working directory using a default filename,
or if \code{filename} is provided, at the location specified.
}
\description{
Provides an example script for use in Earth Engine, as a preceeding step
to using the \code{irg} package. Use the script to sample NDVI in Earth
Engine, then use the \code{irg} package to calculate the instantaneous rate of green-up.
}
