% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{set_ipums_var_attributes}
\alias{set_ipums_var_attributes}
\title{Add IPUMS variable attributes to a data frame}
\usage{
set_ipums_var_attributes(
  data,
  var_info,
  var_attrs = c("val_labels", "var_label", "var_desc")
)
}
\arguments{
\item{data}{\code{\link[tibble:tbl_df-class]{tibble}} or data frame}

\item{var_info}{An \link{ipums_ddi} object or a data frame containing
variable information. Variable information can be obtained by calling
\code{ipums_var_info()} on an \code{ipums_ddi} object.}

\item{var_attrs}{Variable attributes from the DDI to add to the columns of
the output data. Defaults to all available attributes.}
}
\value{
\code{data}, with variable attributes attached
}
\description{
Add variable attributes from an \link{ipums_ddi} object to a data frame.
These provide contextual information about the variables
and values contained in the data columns.

Most ipumsr data-reading functions automatically add these attributes.
However, some data processing operations may remove attributes, or you
may wish to store data in an external database that does not support
these attributes. In these cases, use this function to manually attach
this information.
}
\details{
Attribute \code{val_labels} adds the \code{\link[haven:labelled]{haven_labelled}} class
and the corresponding value labels for applicable variables. For more
about the \code{haven_labelled} class, see
\code{vignette("semantics", package = "haven")}.

Attribute \code{var_label} adds a short summary of the variable's
contents to the \code{"label"} attribute. This label is viewable in the
RStudio Viewer.

Attribute \code{var_desc} adds a longer description of the variable's
contents to the \code{"var_desc"} attribute, when available.

Variable information is attached to the data by column name. If column
names in \code{data} do not match those found in \code{var_info}, attributes
will not be added.
}
\examples{
ddi_file <- ipums_example("cps_00157.xml")

# Load metadata into `ipums_ddi` object
ddi <- read_ipums_ddi(ddi_file)

# Load data
cps <- read_ipums_micro(ddi)

# Data includes variable metadata:
ipums_var_desc(cps$INCTOT)

# Some operations remove attributes, even if they do not alter the data:
cps$INCTOT <- ifelse(TRUE, cps$INCTOT, NA)
ipums_var_desc(cps$INCTOT)

# We can reattach metadata from the separate `ipums_ddi` object:
cps <- set_ipums_var_attributes(cps, ddi)
ipums_var_desc(cps$INCTOT)
}
