% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{is_extract_ready}
\alias{is_extract_ready}
\title{Is the extract ready to download?}
\usage{
is_extract_ready(extract, api_key = Sys.getenv("IPUMS_API_KEY"))
}
\arguments{
\item{extract}{One of:
\itemize{
\item An \code{\link[=ipums_extract-class]{ipums_extract}} object
\item The data collection and extract number formatted as a single string of the
form \code{"collection:number"}
\item The data collection and extract number formatted as a vector of the form
\code{c("collection", "number")}
}

The extract number does not need to be zero-padded (e.g., use \code{"usa:1"}
or \code{c("usa", "1")}, not \code{"usa:00001"} or \code{c("usa", "00001")}).
See Examples section below for examples of each form.

For a list of codes used to refer to each collection, see
\code{\link[=ipums_data_collections]{ipums_data_collections()}}.}

\item{api_key}{API key associated with your user account. Defaults to the
value of environment variable "IPUMS_API_KEY".}
}
\value{
A logical vector of length one.
}
\description{
This function uses the IPUMS API to check whether the given extract is ready
to download, returning TRUE for extracts that are ready and FALSE for those
that are not. For an overview of ipumsr microdata API functionality, see
\code{vignette("ipums-api", package = "ipumsr")}.
}
\details{
This function checks the "download_links" element of the supplied extract to
determine whether the extract files are available to download.
The "status" of a submitted extract is one of "queued", "started", "produced",
"canceled", "failed", or "completed". Only "completed" extracts can be ready
to download, but not all "completed" extracts are ready to download, because
extract files are subject to removal from the IPUMS servers 72 hours after
they first become available. Completed extracts older than 72 hours will
still have a "completed" status, but will return \code{FALSE} from
\code{is_extract_ready()}, because the extract files are no longer available.
}
\examples{
my_extract <- define_extract_usa("Example", "us2013a", "YEAR")

\dontrun{
submitted_extract <- submit_extract(my_extract)

# Check if extract is ready by supplying an ipums_extract object:
is_extract_ready(submitted_extract)

# By supplying the data collection and extract number, as a string:
is_extract_ready("usa:1")
# Note that there is no space before or after the colon, and no zero-padding
# of the extract number.

# By supplying the data collection and extract number, as a vector:
is_extract_ready(c("usa", "1"))
}

}
\seealso{
Other ipums_api: 
\code{\link{add_to_extract}()},
\code{\link{define_extract_cps}()},
\code{\link{define_extract_from_json}()},
\code{\link{define_extract_usa}()},
\code{\link{download_extract}()},
\code{\link{extract_list_to_tbl}()},
\code{\link{extract_tbl_to_list}()},
\code{\link{get_extract_info}()},
\code{\link{get_last_extract_info}()},
\code{\link{get_recent_extracts_info}},
\code{\link{ipums_data_collections}()},
\code{\link{remove_from_extract}()},
\code{\link{save_extract_as_json}()},
\code{\link{set_ipums_api_key}()},
\code{\link{submit_extract}()},
\code{\link{wait_for_extract}()}
}
\concept{ipums_api}
