% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddi_read.r
\name{read_ipums_codebook}
\alias{read_ipums_codebook}
\title{Read metadata from a text codebook in a NHGIS or Terra area-level extract}
\usage{
read_ipums_codebook(cb_file, data_layer = NULL)
}
\arguments{
\item{cb_file}{Filepath to the codebook (either the .zip file directly downloaded
from the website, or the path to the unzipped .txt file).}

\item{data_layer}{dplyr \code{\link[dplyr]{select}}-style notation for uniquely
identifying the data layer to load. Required for reading from .zip files
 for extracts with multiple files.}
}
\value{
A \code{ipums_ddi} object with information on the variables included in the
  csv file of a NHGIS extract.
}
\description{
Read text formatted codebooks provided by some IPUMS extract systems such as
NHGIS and Terra Area-level extracts in a format analogous to the DDIs
available for other projects.
}
\examples{
# Example NHGIS extract
nhgis_file <- ipums_example("nhgis0008_csv.zip")
ddi <- read_ipums_codebook(nhgis_file)
}
\seealso{
Other ipums_metadata: \code{\link{read_ipums_ddi}}
}
