% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slope.R
\name{slope}
\alias{slope}
\title{Recover the betas (slopes) of the regression curves}
\usage{
slope(object)
}
\arguments{
\item{object}{Object of class "ipriorMod"}
}
\value{
The slopes of the fitted regression curves.
}
\description{
Since an I-prior model does not deal with the betas (slopes or coefficients
of an ordinary linear model), this function calculates the slopes of the
regression curves based on the fitted values. While it is meant for Canonical
RKHS functions, it still works for FBM RKHS, in that the slopes returned
would be the "average" slope, i.e. the slope of the fitted straight line
through the fitted I-prior values. Currently, only models with one
explanatory variable are supported.
}
\examples{
mod.iprior <- iprior(stack.loss ~ Air.Flow, data = stackloss)
slope(mod.iprior)

}

