% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppi_ols.R
\name{ppi_ols}
\alias{ppi_ols}
\title{PPI OLS}
\usage{
ppi_ols(X_l, Y_l, f_l, X_u, f_u, w_l = NULL, w_u = NULL)
}
\arguments{
\item{X_l}{(matrix): n x p matrix of covariates in the labeled data.}

\item{Y_l}{(vector): n-vector of labeled outcomes.}

\item{f_l}{(vector): n-vector of predictions in the labeled data.}

\item{X_u}{(matrix): N x p matrix of covariates in the unlabeled data.}

\item{f_u}{(vector): N-vector of predictions in the unlabeled data.}

\item{w_l}{(ndarray, optional): Sample weights for the labeled data set.
Defaults to a vector of ones.}

\item{w_u}{(ndarray, optional): Sample weights for the unlabeled
data set. Defaults to a vector of ones.}
}
\value{
(list): A list containing the following:

\describe{
\item{est}{(vector): vector of PPI OLS regression coefficient
estimates.}
\item{se}{(vector): vector of standard errors of the coefficients.}
\item{rectifier_est}{(vector): vector of the rectifier OLS
regression coefficient estimates.}
}
}
\description{
Helper function for prediction-powered inference for OLS estimation
}
\details{
Prediction Powered Inference (Angelopoulos et al., 2023)
\url{https://www.science.org/doi/10.1126/science.adi6000}
}
\examples{

dat <- simdat()

form <- Y - f ~ X1

X_l <- model.matrix(form, data = dat[dat$set == "labeled",])

Y_l <- dat[dat$set == "labeled", all.vars(form)[1]] |> matrix(ncol = 1)

f_l <- dat[dat$set == "labeled", all.vars(form)[2]] |> matrix(ncol = 1)

X_u <- model.matrix(form, data = dat[dat$set == "unlabeled",])

f_u <- dat[dat$set == "unlabeled", all.vars(form)[2]] |> matrix(ncol = 1)

ppi_ols(X_l, Y_l, f_l, X_u, f_u)

}
