% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pspa_mean.R
\name{pspa_mean}
\alias{pspa_mean}
\title{PSPA Mean Estimation}
\usage{
pspa_mean(Y_l, f_l, f_u, weights = NA, alpha = 0.05)
}
\arguments{
\item{Y_l}{(vector): n-vector of labeled outcomes.}

\item{f_l}{(vector): n-vector of predictions in the labeled data.}

\item{f_u}{(vector): N-vector of predictions in the unlabeled data.}

\item{weights}{(array): 1-dimensional array of weights vector for variance
reduction. PSPA will estimate the weights if not specified.}

\item{alpha}{(scalar): type I error rate for hypothesis testing - values in
(0, 1); defaults to 0.05.}
}
\value{
A list of outputs: estimate of inference model parameters and
corresponding standard error.
}
\description{
Helper function for PSPA mean estimation
}
\details{
Post-prediction adaptive inference
(Miao et al., 2023) \url{https://arxiv.org/abs/2311.14220}
}
\examples{

dat <- simdat(model = "mean")

form <- Y - f ~ 1

Y_l <- dat[dat$set == "labeled",   all.vars(form)[1]] |> matrix(ncol = 1)

f_l <- dat[dat$set == "labeled",   all.vars(form)[2]] |> matrix(ncol = 1)

f_u <- dat[dat$set == "unlabeled", all.vars(form)[2]] |> matrix(ncol = 1)

pspa_mean(Y_l, f_l, f_u)

}
